#!/usr/bin/env python
# -*- coding: utf-8 -*-

# partorder.py - mbr partition order changer
# version 0.0.2 - 2012-07-07
# (c) 2012 by PsyBlade - all rights reserved
# http://gbatemp.net/topic/329862-changing-the-partition-order-in-a-faster-way

import sys,io,struct,ctypes,re,time

partst=struct.Struct("<B3xB3xII")
mbr = ctypes.create_string_buffer(512)
parts = [0,0,0,0]
own = [0,0,0,0]

devicename = sys.argv[1]

dev = io.BufferedReader(io.FileIO(devicename,"rb"))
dev.readinto(mbr)
dev.close

for n in range(4):
    raw = mbr[446+16*n:446+16*(n+1)]
    mbr[446+16*n:446+16*(n+1)] = raw
    active, typ, start, size = partst.unpack_from(raw)
    parts[n] = [start==0, start, n, active, typ, size, raw]
parts.sort()

k = 0
while k not in ["s","q"]:
    print 'Partitions in on disk order:'
    print 'Nr  StartSector   SectorCount   Type  LogicalPos'
    for n,p in enumerate(parts):
        print '{0} {2:13} {6:13}   0x{5:02x}  {3}'.format(n,*p)
        own[p[2]] = n
    k = raw_input("Move which partition? (q quits, s saves): ")
    if k in ["0","1","2","3"]:
        target = int(k)
        while k != "a":
            k = raw_input("Move to where? (a aborts): ")
            if k in ["0","1","2","3"]:
                log = int(k)
                parts[own[log]][2] = parts[target][2]
                parts[target][2] = log
                break

if k == "s":
    bname="mbr."+re.sub(":","",devicename.strip().split('\\')[-1].split('/')[-1]+"."+str(int(time.time())))+".back"
    back=open(bname,"wb")
    back.write(mbr)
    back.close()
    for p in parts:
        n = p[2]
        #print p[6]
        mbr[446+16*n:446+16*(n+1)] = p[6]
    dev = io.BufferedRandom(io.FileIO(devicename,"r+b"))
    print "saving"
    dev.write(mbr)
    dev.close
    print "done"
else:
    print "quiting without saving"
